;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-vanilla-reader.ss" "deinprogramm")((modname kapitel-8c) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #f #t none explicit #f ())))
; Kapitel 8

; Rest 

; Liste aufsummieren
(: list-sum ((list-of number) -> number))
(check-expect (list-sum empty) 0)
(check-expect (list-sum (list 3 5 7)) 15)
(check-expect (list-sum (list 10 20 30 40)) 100)

(define list-sum
  (lambda (lis)
    (cond
      ((empty? lis) 0)
      ((pair? lis) 
       (+ (first lis)
          (list-sum (rest lis)))))))

; Liste aufmultiplizieren
(: list-product ((list-of number) -> number))
(check-expect (list-product empty) 1)
(check-expect (list-product (list 3 5 7)) 105)
(check-expect (list-product (list 10 20 30 40)) 240000) 

(define list-product
  (lambda (lis)
    (cond
      ((empty? lis) 1)
      ((pair? lis) 
       (* (first lis)
          (list-product (rest lis)))))))

; die Elemente einer Liste kombinieren
(: list-fold (%a (%a %b -> %b) (list-of %a) -> %b)) 
(check-expect (list-fold 1 * (list 1 2 3 4)) 24)
(check-expect (list-fold (list 4 5 6) make-pair (list 1 2 3)) (list 1 2 3 4 5 6))
(check-expect (list-fold "" (lambda (first rest) 
                              (string-append 
                               (number->string first) 
                               rest)) 
                         (list 1 2 3)) "123")

(define list-fold
  (lambda (unit combine lis)
    (cond
      ((empty? lis) unit)
      ((pair? lis) 
       (combine (first lis)
                (list-fold unit combine (rest lis)))))))


; Länge n + 1
(: add-1-for-length (%a number -> number))
(define add-1-for-length
  (lambda (ignore n)
    (+ n 1)))

(check-expect (list-fold 0 add-1-for-length (list 1 2 3 4 5)) 5)
(check-expect (list-fold 0 (lambda (ignore n) (+ n 1)) (list 1 2 3 4 5)) 5)

; aus einer Liste eine Liste der Elemente bilden,
; die eine bestimmte Eigenschaft haben
(: filter ((%a -> boolean) (list-of %a) -> (list-of %a)))
(check-expect (filter even? (list 1 2 3 4 5)) (list 2 4))
(check-expect (filter (lambda (s) (string=? s "Mike")) (list "Mike" "Herb" "Mike" "Mike")) (list "Mike" "Mike" "Mike"))

(define filter
  (lambda (p? lis)
    (list-fold empty
               (lambda (first result)
                 (if (p? first)
                     (make-pair first result)
                     result))
               lis)))

; prüfen, ob Prädikat auf alle Elemente einer Liste zutrifft
(: every? ((%a -> boolean) (list-of %a) -> boolean))
(check-expect (every? even? (list 1 2 3 4 5)) #f)
(check-expect (every? even? (list 6 2 18 4 20)) #t)
(check-expect (every? (lambda (s) (string=? s "Mike")) (list "Mike" "Herb" "Mike" "Mike")) #f)
(check-expect (every? (lambda (s) (string=? s "Mike")) (list "Mike" "Mike" "Mike")) #t)

(define every?
  (lambda (p? lis)
    (list-fold #t
               (lambda (first result)
                 (and result
                      (p? first)))
               lis)))

; zwei Prozeduren komponieren
(: compose ((%a -> %b) (%b -> %c) -> (%a -> %c)))
(check-expect ((compose (lambda (x) (+ x 1)) (lambda (x) (* x 2))) 5) 11)
(check-expect ((compose even? (lambda (x) (* x 2))) 5) #t)

(define compose
  (lambda (f g)
    (lambda (x)
      (f (g x)))))

; Prozedur wiederholt anwenden
(: repeat (natural (%a -> %a) -> (%a -> %a)))
(check-expect ((repeat 5 (lambda (n) (* n 2))) 1) 32)
(check-expect ((repeat 10 (lambda (n) (+ n 1))) 0) 10)

(define repeat
  (lambda (n proc)
    (if (= n 0)
        (lambda (x) x)
        (compose proc (repeat (- n 1) proc)))))

; Prozedur erzeugen, die eine Konstante addiert
(: make-add (number -> (number -> number)))
(check-expect ((make-add 5) 7) 12)
(check-expect ((make-add 0) 7) 7)

(define make-add
  (lambda (a)
    (lambda (b)
      (+ a b))))

; Prozedur erzeugen, die mit einer Konstante multipliziert
(: make-mult (number -> (number -> number)))
(check-expect ((make-mult 5) 7) 35)
(check-expect ((make-mult 1) 7) 7)

(define make-mult
  (lambda (a)
    (lambda (b)
      (* a b))))

; Prozedur erzeugen, die an eine Liste ein Element vorn anhängt
(: make-prepend (%a -> ((list-of %a) -> (list-of %a))))
(check-expect ((make-prepend 5) (list 1 2 3)) (list 5 1 2 3))
(check-expect ((make-prepend "A") (list "B" "C" "D")) (list "A" "B" "C" "D"))

(define make-prepend
  (lambda (a)
    (lambda (b)
      (make-pair a b))))

; Prozedur mit zwei Parametern staffeln
(: curry ((%a %b -> %c) -> (%a -> (%b -> %c))))
(check-expect (((curry +) 5) 7) 12)
(check-expect (((curry *) 5) 7) 35)
(check-expect (((curry make-pair) 5) (list 1 2 3)) (list 5 1 2 3))

(define curry
  (lambda (proc)
    (lambda (a)
      (lambda (b)
        (proc a b)))))

; Prozedur zu einer Prozedur mit zwei Parametern entstaffeln
(: uncurry ((%a -> (%b -> %c)) -> (%a %b -> %c)))
(check-expect ((uncurry make-add) 5 7) 12)
(check-expect ((uncurry make-mult) 5 7) 35)
(check-expect ((uncurry make-prepend) 5 (list 1 2 3)) (list 5 1 2 3))
(check-expect ((uncurry (curry make-pair)) "A" (list "B" "C" "D")) (list "A" "B" "C" "D"))

(define uncurry 
  (lambda (proc)
    (lambda (a b)
      ((proc a) b))))