;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-vanilla-reader.ss" "deinprogramm")((modname kapitel-akku) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #f #t none explicit #f ())))
; Kapitel "Programmieren mit Akkumulatoren"

; Liste umdrehen
(: invert ((list-of %a) -> (list-of %a)))

(check-expect (invert empty) empty)
(check-expect (invert (list 1 2 3 4)) (list 4 3 2 1))

#;(define invert
  (lambda (lis)
    (cond
      ((empty? lis) empty)
      ((pair? lis)
       (append-element (invert (rest lis))
                       (first lis))))))

(define invert
  (lambda (lis)
    (invert-1 lis empty)))

(define invert-1
  (lambda (lis acc)
    (cond
      ((empty? lis)
       acc)
      ((pair? lis)
       (invert-1 (rest lis)
                 (make-pair (first lis) acc))))))

; Element an Liste anhängen
(: append-element ((list-of %a) %a -> (list-of %a)))

(check-expect (append-element (list 1 2 3) 4) (list 1 2 3 4))
(check-expect (append-element empty 4) (list 4))

(define append-element
  (lambda (lis el)
    (cond
      ((empty? lis)
       (list el))
      ((pair? lis)
       (make-pair (first lis)
                  (append-element (rest lis) el))))))


; maximales Element einer Liste berechnen
(: list-max ((list real) -> real))

(check-expect (list-max (list 1 2 3 4)) 4)
(check-expect (list-max (list 4 3 1 3)) 4)
(check-expect (list-max (list 1 4 2 3)) 4)
(check-error (list-max empty) "Maximum einer leeren Liste")

(define list-max
  (lambda (lis)
    (cond
      ((empty? lis)
       (violation "Maximum einer leeren Liste"))
      ((pair? lis)
       (cond
         ((empty? (rest lis))
          (first lis))
         ((pair? (rest lis))
          (max (first lis)
               (list-max (rest lis)))))))))

; maximal möglichen Kursgewinn ausrechnen
(: max-win ((list real) -> real))

(check-expect (max-win (list 1 2 3 4)) 3)
(check-expect (max-win (list 4 1 2 3)) 2)
(check-expect (max-win (list 4 1 2 3 4 1 5)) 4)
(check-expect (max-win empty) 0)
(check-expect (max-win (list 4)) 0)

(define max-win
  (lambda (lis)
    (cond
      ((empty? lis)
       0)
      ((pair? lis)
       (cond
         ((empty? (rest lis))
          0)
         ((pair? (rest lis))
          (max (list-max (map (lambda (s)
                                (- s (first lis)))
                              (rest lis)))
               (max-win (rest lis)))))))))

; Liste mit aufsteigenden Zahlen bilden

(: ascending-list (natural -> (list natural)))

(check-expect (ascending-list 0) empty)
(check-expect (ascending-list 5) (list 1 2 3 4 5))

(define ascending-list
  (lambda (n)
    (reverse (ascending-list-1 n))))
     
(define ascending-list-1
  (lambda (n)
    (if (= n 0)
        empty
        (make-pair n (ascending-list-1 (- n 1))))))
 

#;(define max-win
  (lambda (lis)
    (max-win-helper lis 0)))

