;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-assignments-reader.ss" "deinprogramm")((modname kapitel-13a) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #t #t none explicit #f ())))
; Kapitel 13

; Objekte, erster Anlauf

; Liste von Zeichenketten in der REPL ausdrucken
(: write-list-newline ((list string) -> unspecific))
(define write-list-newline
  (lambda (lis)
    (begin
      (for-each (lambda (s)
                  (write-string s))
                lis)
      (write-newline))))

; Nachrichten sind Zeichenketten
(define message (contract string))
; Prozedur mit unbekanntem Vertrag
(define method (contract %a))

; Konto konstruieren
(: make-account (rational -> (message -> method)))
; message = "get-balance" or "withdraw"
; method = ... -> ...

(check-expect (let ((acc (make-account 5000)))
                (begin
                  ((acc "withdraw") 10)
                  ((acc "get-balance"))))
              4990)

(define make-account
  (lambda (balance)
    (lambda (message)
      (cond
        ((equal? message "get-balance")
         ;; Kontostand zurückgeben
         ;; -> number
         (lambda ()
           balance))
        ((equal? message "withdraw")
         ;; Betrag von Konto abheben
         ;; number -> number or #f
         (lambda (amount)
           (if (>= balance amount)
               (begin
                 (set! balance (- balance amount))
                 balance)
               #f)))))))

; Person konstruieren
(: make-person (string -> (message -> method)))

(check-expect (let ((george (make-person "George")))
                ((george "get-name")))
              "George")

(define make-person
  (lambda (name)
    (lambda (message)
      (cond ((equal? message "get-name")
             ;; Namen zurückgeben
             ;; -> string
             (lambda ()
               name))
            ((equal? message "say")
             ;; Text aufsagen
             ;; list(string) -> unspecified
             (lambda (stuff)
               (write-list-newline stuff)))))))
