;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-beginner-reader.ss" "deinprogramm")((modname kapitel-6) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #f #t none explicit #f ())))
; Kapitel 6

; Eine Liste ist
; - die leere Liste oder
; - ein Paar
; Name: list-of-any
(define list-of-any (signature (mixed empty-list pair)))

; Ein Paar besteht aus
; - einem Wert
; - einer Liste
(: make-pair (%a list-of-any -> pair))
(: pair? (any -> boolean))
(: first (pair -> %a))
(: rest (pair -> list-of-any))

(define-record-procedures pair
  make-pair pair?
  (first rest))

;; Eine Liste von Zahlen ist
;; - die leere Liste oder
;; - ein Paar von Zahlen
;; Name: list-of-numbers
;(define list-of-numbers (signature (mixed pair-of-number empty-list)))
;
;; Ein Paar von Zahlen besteht aus
;; - einer Nummer
;; - einer Liste von Zahlen
;(: make-pair-of-numbers (number list-of-numbers -> pair-of-numbers))
;(: pair-of-numbers? (any -> boolean))
;(: first (pair-of-numbers -> number))
;(: rest (pair-of-numbers -> list-of-numbers))
;
;(define-record-procedures pair-of-numbers
;  make-pair-of-numbers pair-of-numbers?
;  (first rest))

; Elemente einer Liste summieren
(: list-sum (list-of-any -> number))
(check-expect (list-sum (make-pair 1 (make-pair 7 (make-pair 3 empty)))) 11)
(check-expect (list-sum empty) 0)
(define list-sum
  (lambda (lis)
    (cond
      ((empty? lis) 0)
      ((pair? lis) 
       (+ (first lis)
          (list-sum (rest lis)))))))

; das Produkt aller Zahlen von 1 bis n berechnen
(: factorial (natural -> natural))
(check-expect (factorial 0) 1)
(check-expect (factorial 1) 1)
(check-expect (factorial 5) 120)
(define factorial
  (lambda (n)
    (if (= n 0)
        1
        (* n (factorial (- n 1))))))

; Rätselprozedur
(define f
  (lambda (n)
    (if (= n 0)
        0
        (+ (f (- n 1))
           (/ 1 (* n (+ n 1)))))))

; das Produkt aller Zahlen von 1 bis n berechnen
; (: factorial (number -> number))
; (define factorial
;   (lambda (n)
;     (factorial-helper n 1)))

; das Produkt aller Zahlen von 1 bis n akkumulieren
; (: factorial-helper (number number -> number))
; (define factorial-helper
;   (lambda (n result)
;     (if (= n 0)
;         result
;         (factorial-helper (- n 1) (* n result)))))

; (define f
;   (lambda (n)
;     (f-helper n 0)))

; (define f-helper
;   (lambda (n result)
;     (if (= n 0)
;         result
;         (f-helper (- n 1)
;                   (+ (/ 1 (* n (+ n 1)))
;                      result)))))

; Zahl um 1 erhöhen
(: increment (number -> number))
(check-expect (increment 4) 5)

(define increment
  (lambda (n)
    (+ n 1)))

; Zahl um 1 erniedrigen
(: decrement (number -> number))
(check-expect (decrement 5) 4)

(define decrement
  (lambda (n)
    (- n 1)))

; Quadrat einer Zahl berechnen
(: square (number -> number))
(check-expect (square 0) 0)
(check-expect (square 1) 1)
(check-expect (square 3) 9)

(define square
  (lambda (n)
    (square-helper n 0)))

; Quadrat einer Zahl akkumulieren
(: square-helper (number number -> number))
(define square-helper
  (lambda (n result)
    (if (= n 0)
        result
        (square-helper (- n 1)
                       (+ result
                          (- (+ n n) 1))))))
